﻿/* list of events:
    
app events:
    
- onSequenceActivated
- onActiveSequenceChanged
- onActiveSequenceSelectionChanged
- onActiveSequenceStructureChanged
- onSourceClipSelectedInProjectPanel
- onActiveSequenceTrackItemAdded
- onActiveSequenceTrackItemRemoved
- onProjectChanged
- onProjectEndDrop

 *****************************************************

app encoder events:
 
- onEncoderJobCanceled
- onEncoderJobQueued
- onEncoderJobComplete
- onEncoderJobError
- onEncoderJobProgress
- onEncoderLaunched

 */
 
 // map event "onSequenceActivated"
app.addEventListener("onSequenceActivated", function(eventObj)
{
    if (app.onSequenceActivated && typeof app.onSequenceActivated === "function")
    {
        app.onSequenceActivated();
    }
}, false);
 
// map event "onActiveSequenceChanged"
app.addEventListener("onActiveSequenceChanged", function(eventObj)
{
    if (app.onActiveSequenceChanged && typeof app.onActiveSequenceChanged === "function")
    {
        app.onActiveSequenceChanged();
    }
}, false);
 
// map event "onActiveSequenceSelectionChanged"
app.addEventListener("onActiveSequenceSelectionChanged", function(eventObj)
{
    if (app.onActiveSequenceSelectionChanged && typeof app.onActiveSequenceSelectionChanged === "function")
    {
        app.onActiveSequenceSelectionChanged();
    }
}, false);

// map event "onActiveSequenceStructureChanged"
app.addEventListener("onActiveSequenceStructureChanged", function(eventObj)
{
    if (app.onActiveSequenceStructureChanged && typeof app.onActiveSequenceStructureChanged === "function")
    {
        app.onActiveSequenceStructureChanged();
    }
}, false);

// map event "onSourceClipSelectedInProjectPanel"
app.addEventListener("onSourceClipSelectedInProjectPanel", function(eventObj) 
{
    if (app.onSourceClipSelectedInProjectPanel && typeof app.onSourceClipSelectedInProjectPanel === "function")
    {
        app.onSourceClipSelectedInProjectPanel(eventObj.selectedItems, eventObj.projectViewID);
    }
}, false);

// map event "onActiveSequenceTrackItemAdded"
app.addEventListener("onActiveSequenceTrackItemAdded", function(eventObj)
{
    if (app.onActiveSequenceTrackItemAdded && typeof app.onActiveSequenceTrackItemAdded === "function")
    {
        app.onActiveSequenceTrackItemAdded(eventObj.track, eventObj.trackItemAdded);
    }
}, false);

// map event "onActiveSequenceTrackItemRemoved"
app.addEventListener("onActiveSequenceTrackItemRemoved", function(eventObj)
{
    if (app.onActiveSequenceTrackItemRemoved && typeof app.onActiveSequenceTrackItemRemoved === "function")
    {
        app.onActiveSequenceTrackItemRemoved(eventObj.track, eventObj.trackItemRemoved);
    }
}, false);
 
// map event "onProjectChanged"
app.addEventListener("onProjectChanged", function(eventObj)
{
    if (app.onProjectChanged && typeof app.onProjectChanged === "function")
    {
        app.onProjectChanged(eventObj.projectID);
    }
}, false);

// map event "onProjectEndDrop"
app.addEventListener("onProjectEndDrop", function(eventObj)
{
    if (app.onProjectChanged && typeof app.onProjectChanged === "function")
    {
        app.onProjectChanged(eventObj.projectID);
    }
}, false);

// Store app events associated with listener and handler while do bind
var appEventsDict = {}; 

// binding support for "app" events
if (!app.bind)
{
     app.bind = function(inEventName, inHandler)
     {
           if (inHandler && typeof inHandler === 'function')
           {
                var listener = function(inEventObj)
                {
                    var info = appEventsDict[inEventName];
                    if (info && info.handler && typeof info.handler === 'function')
                    {
                        switch (inEventName)
                        {
                            case "onSourceClipSelectedInProjectPanel":
                                info.handler(inEventObj.selectedItems, inEventObj.projectViewID);
                                break;
                            case "onActiveSequenceTrackItemAdded":
                                info.handler(inEventObj.track, inEventObj.trackItemAdded);
                                break;
                            case "onActiveSequenceTrackItemRemoved":
                                info.handler(inEventObj.track, inEventObj.trackItemRemoved);
                                break;
                            case "onProjectChanged":
                            case "onProjectEndDrop":
                                info.handler(inEventObj.projectID);
                                break;
                            default:
                                info.handler();
                                break;
                        }
                    }
                }
                appEventsDict[inEventName] = {"listener":listener, "handler":inHandler};
                app.addEventListener(inEventName, listener, false); 
                return true;
           }
           return false;
     }
}

// unbinding support for "app" events
if (!app.unbind)
{
    app.unbind = function(inEventName, inHandler)
    {
        if (inHandler && typeof inHandler === 'function')
        {
            var info = appEventsDict[inEventName];
            if (info && info.listener && typeof info.listener === 'function')
            {
                app.removeEventListener(inEventName, info.listener);
                return true;
            }
        }
        return false;
    }
}

// setTimeout support for "app" object
if (!app.setTimeout)
{
    app.setTimeout = function(inFct, inMilliseconds)
    {
        var timeoutObj = new Timeout(inMilliseconds);
        timeoutObj.addEventListener("onTimeout", function(eventObj)
        {
            if (inFct && typeof inFct === 'function') 
            {
                inFct();
            }
        }, false);
    }
}
 
// ****************************************************************************************
 
 // map event "onEncoderJobCanceled"
app.encoder.addEventListener("onEncoderJobCanceled", function(eventObj)
{
    if (app.encoder.onEncoderJobCanceled && typeof app.encoder.onEncoderJobCanceled === "function")
    {
        app.encoder.onEncoderJobCanceled(eventObj.jobID);
    }
}, false);

// map event "onEncoderJobQueued"
app.encoder.addEventListener("onEncoderJobQueued", function(eventObj)
{
    if (app.encoder.onEncoderJobQueued && typeof app.encoder.onEncoderJobQueued === "function")
    {
        app.encoder.onEncoderJobQueued(eventObj.jobID);
    }
}, false);

// map event "onEncoderJobComplete"
app.encoder.addEventListener("onEncoderJobComplete", function(eventObj)
{
    if (app.encoder.onEncoderJobComplete && typeof app.encoder.onEncoderJobComplete === "function")
    {
        app.encoder.onEncoderJobComplete(eventObj.jobID, eventObj.outputFile);
    }
}, false);

// map event "onEncoderJobError"
app.encoder.addEventListener("onEncoderJobError", function(eventObj)
{
    if (app.encoder.onEncoderJobError && typeof app.encoder.onEncoderJobError === "function")
    {
        app.encoder.onEncoderJobError(eventObj.jobID, eventObj.errorString);
    }
}, false);

// map event "onEncoderJobProgress"
app.encoder.addEventListener("onEncoderJobProgress", function(eventObj)
{
     if (app.encoder.onEncoderJobProgress && typeof app.encoder.onEncoderJobProgress === "function")
    {
        app.encoder.onEncoderJobProgress(eventObj.jobID, eventObj.progress);
    }
}, false);

// map event "onEncoderLaunched"
app.encoder.addEventListener("onEncoderLaunched", function(eventObj)
{
    if (app.encoder.onEncoderLaunched && typeof app.encoder.onEncoderLaunched === "function")
    {
        app.encoder.onEncoderLaunched(eventObj.launchSuccess);
    }
}, false);

// Store encoder events associated with listener and handler while do bind
var encoderEventsDict = {};

// binding support for "app.encoder" events
if (!app.encoder.bind)
{
     app.encoder.bind = function(inEventName, inHandler)
     {
           if (inHandler && typeof inHandler === 'function')
           {
                var listener = function(inEventObj)
                {
                    var info = encoderEventsDict[inEventName];
                    if (info && info.handler && typeof info.handler === 'function')
                    {
                        switch (inEventName)
                        {
                            case "onEncoderJobCanceled":
                                info.handler(inEventObj.jobID);
                                break;
                            case "onEncoderJobQueued":
                                info.handler(inEventObj.jobID);
                                break;
                            case "onEncoderJobComplete":
                                info.handler(inEventObj.jobID, inEventObj.outputFile);
                                break;
                            case "onEncoderJobError":
                                info.handler(inEventObj.jobID, inEventObj.errorString);
                                break;
                            case "onEncoderJobProgress":
                                info.handler(inEventObj.jobID, inEventObj.progress);
                                break;
                            case "onEncoderLaunched":
                                info.handler(inEventObj.launchSuccess);
                                break;
                            default:
                                info.handler();
                                break;
                        }
                    }
                }
                encoderEventsDict[inEventName] = {"listener":listener, "handler":inHandler};
                app.encoder.addEventListener(inEventName, listener, false); 
                return true;
           }
           return false;
     }
}

// unbinding support for "app.encoder" events
if (!app.encoder.unbind)
{
    app.encoder.unbind = function(inEventName, inHandler)
    {
        if (inHandler && typeof inHandler === 'function')
        {
            var info = encoderEventsDict[inEventName];
            if (info && info.listener && typeof info.listener === 'function')
            {
                app.encoder.removeEventListener(inEventName, info.listener);
                return true;
            }
        }
        return false;
    }
}

// setTimeout support for "app.encoder" object
if (!app.encoder.setTimeout)
{
    app.encoder.setTimeout = function(inFct, inMilliseconds)
    {
        var timeoutObj = new Timeout(inMilliseconds);
        timeoutObj.addEventListener("onTimeout", function(eventObj)
        {
           if (inFct && typeof inFct === 'function') 
            {
                inFct();
            }
        }, false);
    }
}